﻿using IpPbx.Samples.Shared;
using System;
using System.Windows.Forms;

namespace IpPbx.ViewActiveCalls
{
    public partial class frmMain : Form
    {
        private CDSLib _cdsLib;

        //------------------------------------------------------------------------------------

        public frmMain()
        {
            InitializeComponent();
        }

        //------------------------------------------------------------------------------------

        private void cmdLogin_Click(object sender, EventArgs e)
        {
            _cdsLib = new CDSLib(txtName.Text,
                                      txtPassword.Text,
                                      txtServer.Text);

            if (this._cdsLib.TestConnection())
            {
                txtName.Enabled = false;
                txtPassword.Enabled = false;
                txtServer.Enabled = false;
                cmdLogin.Enabled = false;
                cmdLoad.Enabled = true;
            }
            else
            {
                MessageBox.Show("Connection failed", "Error",
                    MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        //------------------------------------------------------------------------------------

        private void cmdLoad_Click(object sender, EventArgs e)
        {
            try
            {
                dgvPhonebook.Rows.Clear();

                var activeCalls = _cdsLib.GetActiveCalls();

                tslCounter.Text = $"Active Calls: {activeCalls.Count}";

                foreach (var callEntry in activeCalls)
                {
                    var rowId = dgvPhonebook.Rows.Add();
                    dgvPhonebook.Rows[rowId].Cells[0].Value = callEntry.CallID.ToString();
                    dgvPhonebook.Rows[rowId].Cells[1].Value = callEntry.CallStatus.ToString();
                    dgvPhonebook.Rows[rowId].Cells[2].Value = callEntry.Start.ToString();
                    dgvPhonebook.Rows[rowId].Cells[3].Value = callEntry.Duration.ToString();
                    dgvPhonebook.Rows[rowId].Cells[4].Value = callEntry.CalledName;
                    dgvPhonebook.Rows[rowId].Cells[5].Value = callEntry.CalledNumber;
                    dgvPhonebook.Rows[rowId].Cells[6].Value = callEntry.DestinationDeviceName;
                    dgvPhonebook.Rows[rowId].Cells[7].Value = callEntry.DestinationName;
                    dgvPhonebook.Rows[rowId].Cells[8].Value = callEntry.DestinationNumber;
                    dgvPhonebook.Rows[rowId].Cells[9].Value = callEntry.OriginationDeviceName;
                    dgvPhonebook.Rows[rowId].Cells[10].Value = callEntry.OriginationName;
                    dgvPhonebook.Rows[rowId].Cells[11].Value = callEntry.OriginationNumber;
                    dgvPhonebook.Rows[rowId].Cells[12].Value = callEntry.ProjectNumber;
                    dgvPhonebook.Rows[rowId].Cells[13].Value = callEntry.Charges;
                }

                activeCalls = null;

                cmdLoad.Text = "Update";
            }
            catch (Exception exception)
            {
                MessageBox.Show(exception.Message, "Exception", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        //------------------------------------------------------------------------------------
    }
}
