﻿using IpPbx.Samples.Shared;
using System;
using System.Windows.Forms;

namespace IpPbx.UserView
{
    public partial class frmMain : Form
    {
        private CDSLib _cdsLib;

        //------------------------------------------------------------------------------------

        public frmMain()
        {
            InitializeComponent();
        }

        //------------------------------------------------------------------------------------

        private void cmdLogin_Click(object sender, EventArgs e)
        {
            _cdsLib = new CDSLib(txtName.Text,
                                      txtPassword.Text,
                                      txtServer.Text);

            if (this._cdsLib.TestConnection())
            {
                txtName.Enabled = false;
                txtPassword.Enabled = false;
                txtServer.Enabled = false;
                cmdLogin.Enabled = false;
                cmdUpdate.Enabled = false;
                cmdLoad.Enabled = true;
            }
            else
            {
                MessageBox.Show("Connection failed", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        //------------------------------------------------------------------------------------

        private void LoadView()
        {
            try
            {
                dgvPhonebook.Rows.Clear();

                var userView = _cdsLib.GetUserView(false);

                tslCounter.Text = $"Results: {userView.Count}";

                foreach (var entry in userView)
                {
                    var rowId = dgvPhonebook.Rows.Add();
                    dgvPhonebook.Rows[rowId].Cells[0].Value = entry.UserID;
                    dgvPhonebook.Rows[rowId].Cells[1].Value = entry.Name;
                    dgvPhonebook.Rows[rowId].Cells[2].Value = entry.Comment;
                    dgvPhonebook.Rows[rowId].Cells[3].Value = entry.EMailAddr;
                    dgvPhonebook.Rows[rowId].Cells[4].Value = entry.Locked;
                    dgvPhonebook.Rows[rowId].Cells[5].Value = entry.LoginTimeLocal;
                }

                cmdLoad.Enabled = false;
                cmdUpdate.Enabled = true;
                userView = null;
            }
            catch (Exception exception)
            {
                MessageBox.Show(exception.Message, "Exception", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        //------------------------------------------------------------------------------------

        private void cmdLoad_Click(object sender, EventArgs e)
        {
            LoadView();
        }

        //------------------------------------------------------------------------------------

        private void cmdUpdate_Click(object sender, EventArgs e)
        {
            LoadView();
        }

        //------------------------------------------------------------------------------------

    }
}
