﻿using IpPbx.Samples.Shared;
using SWConfigDataClientLib.Proxies.Admin;
using System;
using System.Linq;
using System.Windows.Forms;

namespace IpPbx.EditUser
{
    public partial class frmMain : Form
    {
        #region Fields & CTor

        private CDSLib _cdsLib;
        private UserAdminView1EntrySortableCollection _userView;
        private UserAdminView1Entry currentUserEntry;

        public frmMain()
        {
            InitializeComponent();
        }

        #endregion

        #region UI Interaction

        private void btnLogin_Click(object sender, EventArgs e)
        {
            _cdsLib = new CDSLib(txtName.Text,
                                     txtPassword.Text,
                                     txtServer.Text);

            if (!_cdsLib.TestConnection())
            {
                MessageBox.Show("Connection failed", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            if (!LoadUsers())
            {
                return;
            }

            txtName.Enabled = false;
            txtPassword.Enabled = false;
            txtServer.Enabled = false;
            btnLogin.Enabled = false;
            btnRefresh.Enabled = true;
        }

        private void btnRefresh_Click(object sender, EventArgs e)
        {
            LoadUsers();
        }

        private void lbxUsers_SelectedValueChanged(object sender, EventArgs e)
        {
            try
            {
                var selectedUsers = lbxUsers.SelectedItems;
                var userEntry = _userView.FirstOrDefault(x => x.Name == selectedUsers[0].ToString());
                if (userEntry == null)
                {
                    txtUsername.Text = "";
                    txtUsername.Enabled = false;
                    txtUserDescription.Text = "";
                    txtUserDescription.Enabled = false;
                    cbxUserEnabled.Enabled = false;
                    btnSave.Enabled = false;
                    btnDeleteUser.Enabled = false;
                    throw new ArgumentException("User could not be loaded");
                }

                txtUsername.Enabled = true;
                txtUsername.Text = userEntry.Name;

                txtUserDescription.Enabled = true;
                txtUserDescription.Text = userEntry.Comment;

                cbxUserEnabled.Enabled = true;
                cbxUserEnabled.Checked = !userEntry.Locked;

                btnSave.Enabled = true;
                btnDeleteUser.Enabled = true;

                currentUserEntry = userEntry;
            }
            catch (Exception exception)
            {
                MessageBox.Show(exception.Message, "Exception", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnSave_Click(object sender, EventArgs e)
        {
            try
            {
                // Do you we have at least one valid user?
                if (currentUserEntry == null)
                {
                    throw new ArgumentException("No valid user selected");
                }

                // Update user
                _cdsLib.UpdateUser(currentUserEntry.UserID, txtUsername.Text, txtUserDescription.Text, cbxUserEnabled.Checked);

                MessageBox.Show($"User {txtUsername.Text} updated successfully.", "Information", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            catch (Exception exception)
            {
                MessageBox.Show(exception.Message, "Exception", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void btnDeleteUser_Click(object sender, EventArgs e)
        {
            try
            {
                // Do you we have at least one valid user?
                if (currentUserEntry == null)
                {
                    throw new ArgumentException("No valid user selected");
                }

                var result = MessageBox.Show($"Are you really sure that you want to delete the user '{currentUserEntry.Name}'?",
                    "Warning", MessageBoxButtons.YesNo, MessageBoxIcon.Warning);
                if (result == DialogResult.Yes)
                {
                    _cdsLib.DeleteUser(currentUserEntry.UserID);
                    MessageBox.Show($"User {currentUserEntry.Name} deleted successfully.", "Information", MessageBoxButtons.OK, MessageBoxIcon.Information);

                    LoadUsers();

                    btnDeleteUser.Enabled = false;
                    txtUsername.Enabled = false;
                    txtUserDescription.Enabled = false;
                    cbxUserEnabled.Enabled = false;
                    btnSave.Enabled = false;
                }
            }
            catch (Exception exception)
            {
                MessageBox.Show(exception.Message, "Exception", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        #endregion UI Interaction

        #region Private Methods

        private bool LoadUsers()
        {
            try
            {
                lbxUsers.Items.Clear();

                _userView = _cdsLib.GetUserView(true);

                foreach (var entry in _userView)
                {
                    // Filter builtin user (like Conference & MEM)
                    if (!entry.IsShortnameNull)
                        continue;

                    lbxUsers.Items.Add(entry.Name);
                }

                lbxUsers.Enabled = true;

                return true;
            }
            catch (Exception exception)
            {
                MessageBox.Show(exception.Message, "Exception", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }

            return false;
        }

        #endregion
    }
}
