﻿using IpPbx.Samples.Shared;
using SWConfigDataClientLib.Proxies.Admin;
using SWConfigDataClientLib.Proxies.UserPhoneBook;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace IpPbx.EditPersonalPhonebook
{
    public partial class frmMain : Form
    {
        #region Fields & CTor

        private CDSLib _cdsLib;
        private UserAdminView1EntrySortableCollection _userView;
        private List<UserPhoneBookEntry> _newPersonalPhonebookData;

        public frmMain()
        {
            InitializeComponent();
        }

        #endregion

        #region UI Interaction

        private void btnLogin_Click(object sender, EventArgs e)
        {
            _cdsLib = new CDSLib(txtName.Text,
                                     txtPassword.Text,
                                     txtServer.Text);

            if (!_cdsLib.TestConnection())
            {
                MessageBox.Show("Connection failed", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            if (!LoadUsers())
            {
                return;
            }

            txtName.Enabled = false;
            txtPassword.Enabled = false;
            txtServer.Enabled = false;
            btnLogin.Enabled = false;
            btnRefresh.Enabled = true;
            btnBrowse.Enabled = true;
            btnClearPhonebook.Enabled = true;
        }

        //------------------------------------------------------------------------------------

        private void btnRefresh_Click(object sender, EventArgs e)
        {
            LoadUsers();
        }

        //------------------------------------------------------------------------------------        

        private void cbxAllUsers_CheckedChanged(object sender, EventArgs e)
        {
            for (var x = 0; x < lbxUsers.Items.Count; x++)
            {
                lbxUsers.SetSelected(x, cbxAllUsers.Checked);
            }
        }

        //------------------------------------------------------------------------------------        

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            var result = ofdCsv.ShowDialog();
            if (result != DialogResult.OK)
            {
                return;
            }

            try
            {
                _newPersonalPhonebookData = LoadCsv(ofdCsv.FileName, true);
                if (_newPersonalPhonebookData == null ||
                    _newPersonalPhonebookData.Count == 0)
                {
                    throw new ArgumentException("File contains no valid data.");
                }

                txtCsvFilePath.Text = ofdCsv.FileName;
                cbxClearPersonalPhonebook.Enabled = true;
            }
            catch (Exception exception)
            {
                MessageBox.Show(exception.Message, "Exception", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        //------------------------------------------------------------------------------------

        private void btnImport_Click(object sender, EventArgs e)
        {
            try
            {
                var selectedUsers = lbxUsers.SelectedItems;

                if (selectedUsers == null ||
                    selectedUsers.Count == 0)
                {
                    throw new ArgumentException("No users selected.");
                }

                foreach (var user in selectedUsers)
                {
                    var userEntry = _userView.FirstOrDefault(x => x.Name == user.ToString());
                    if (userEntry == null)
                    {
                        continue;
                    }

                    _cdsLib.ImportPersonalPhonebook(userEntry,
                        _newPersonalPhonebookData,
                        cbxClearPersonalPhonebook.Checked);
                }

                MessageBox.Show("Import completed successfully.", "Information", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            catch (Exception exception)
            {
                MessageBox.Show(exception.Message, "Exception", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        //------------------------------------------------------------------------------------

        private void btnClearPhonebook_Click(object sender, EventArgs e)
        {
            try
            {
                var selectedUsers = lbxUsers.SelectedItems;

                if (selectedUsers == null ||
                    selectedUsers.Count == 0)
                {
                    throw new ArgumentException("No users selected.");
                }

                foreach (var user in selectedUsers)
                {
                    var userEntry = _userView.FirstOrDefault(x => x.Name == user.ToString());
                    if (userEntry == null)
                        continue;

                    _cdsLib.ClearPersonalPhonebook(userEntry);
                }

                MessageBox.Show("Process completed successfully.", "Information", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            catch (Exception exception)
            {
                MessageBox.Show(exception.Message, "Exception", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        //------------------------------------------------------------------------------------

        #endregion UI Interaction

        #region Private Methods

        private bool LoadUsers()
        {
            try
            {
                lbxUsers.Items.Clear();

                _userView = _cdsLib.GetUserView(true);

                foreach (var entry in _userView)
                {
                    // Filter builtin user (like Conference & MEM)
                    if (!entry.IsShortnameNull)
                    {
                        continue;
                    }

                    lbxUsers.Items.Add(entry.Name);
                }

                lbxUsers.Enabled = true;
                cbxAllUsers.Enabled = true;
                btnImport.Enabled = true;

                return true;
            }
            catch (Exception exception)
            {
                MessageBox.Show(exception.Message, "Exception", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }

            return false;
        }

        //------------------------------------------------------------------------------------        

        private List<UserPhoneBookEntry> LoadCsv(string filename, bool ignoreHeader)
        {
            var lines = File.ReadAllLines(filename, Encoding.UTF8);

            if (ignoreHeader)
            {
                lines = lines.Skip(1).ToArray();
            }

            var rowCount = lines.Length;

            var values = new List<UserPhoneBookEntry>();

            for (var r = 0; r < rowCount; r++)
            {
                var row = lines[r].Split(';');

                var entry = new UserPhoneBookEntry
                {
                    Name = $"{row[0]} {row[1]}",
                    Number = row[2],
                    SearchNumber = row[2]
                };

                bool isHidden;
                if (bool.TryParse(row[3], out isHidden))
                {
                    entry.Hide = isHidden;
                }

                values.Add(entry);
            }

            return values;
        }

        #endregion
    }
}
